<?php
set_time_limit(0);
define('LOCAL_BASE_DIR', '/home2/pondercf/public_html/dental/ajax/examples/uploads/clinica_09/');
define('ARCHIVO_CONTROL', LOCAL_BASE_DIR . './backup/backup.in.process');

function ftp_connect_with_retry($ftp_server, $ftp_user_name, $ftp_user_pass)
{
    $intentos = 0;
    while( $intentos<15 )
    {
        $intentos++;
        $conn_id = ftp_connect($ftp_server); 
            
        // iniciar una sesión con nombre de usuario y contraseña
        $login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
            
        // verificar la conexión
        if ((!$conn_id) || (!$login_result)) {  
            echo "¡La conexión FTP ha fallado! <br>";
            echo "Se intentó conectar al $ftp_server por el usuario $ftp_user_name <br>";
        } else {
                break;
        }
        sleep(20);
    }
    if( $intentos>=15 )
        die("Demasiados intentos...");
        
    // activar modo pasivo
    ftp_pasv($conn_id, true);
    return $conn_id;
}

function FTP( $dir, $ftp_server, $ftp_user_name, $ftp_user_pass, $log=false )
{
    $conn_id=ftp_connect_with_retry($ftp_server,$ftp_user_name,$ftp_user_pass);
    
    for( $i=0; $i<count($dir); $i++ )
    {   
       // echo 'Directorio ' . $dir[$i] .'<br>';
        $count = 1;
        $dirname = str_replace ( LOCAL_BASE_DIR , '', $dir[$i], $count );
    
        $remote_dir = REMOTE_BASE_DIR . $dirname;
        
        @ftp_mkdir( $conn_id, $remote_dir);
        
        $list = ftp_nlist ($conn_id , $remote_dir );
        if( $list )
        {
            foreach( $list as &$value)
                $value = str_replace( $remote_dir, '', $value);
        }
        //echo '<pre>' . print_r( $list, true) . '</pre>';
        //continue;
        ftp_chdir($conn_id, $remote_dir);
        
        if( ($files = scandir( $dir[$i] )) )
        {
            foreach( $files as $file )
            {
                if( $file=='..' || $file == '.' || $file == 'error_log')
                    continue;
                    
                if($log)
                    file_put_contents(ARCHIVO_CONTROL, 'Backupeando...');
                    
                $archivo = $dir[$i] . $file;
                if( is_dir($archivo) )
                    continue;
    
                if ($list && in_array($file, $list))
                {
                    //echo "Skipping file $archivo<br>";
                    continue;
                }
    
                $source_file  = $archivo;
                $destination_file = $remote_dir . $file;
                //$upload = ftp_put($conn_id, $destination_file, $source_file, FTP_BINARY);
                $reintentos=0;
                while(!($upload = ftp_put($conn_id, $file, $source_file, FTP_BINARY)) && $reintentos<15)
                {
                    echo "¡La subida FTP ha fallado! $source_file<br>\n";
                    ftp_close($conn_id);
                    sleep(20);
                    $conn_id=ftp_connect_with_retry($ftp_server, $ftp_user_name, $ftp_user_pass);
                    $reintentos++;
                }
                
                // comprobar el estado de la subida
                if (!$upload) {
                    echo "¡La subida FTP ha fallado! $source_file<br>\n";
                } else {
                    echo "Subida de $source_file a $ftp_server como $destination_file<br>\n";
                }
                //echo '<br>';
            }
        }
    }
    
    ftp_close($conn_id);
}
//http://nadeausoftware.com/articles/2007/06/php_tip_how_get_web_page_using_curl
function get_web_page( $url )
{
    $options = array(
        CURLOPT_RETURNTRANSFER => true,     // return web page
        CURLOPT_HEADER         => false,    // don't return headers
        CURLOPT_FOLLOWLOCATION => true,     // follow redirects
        CURLOPT_ENCODING       => "",       // handle all encodings
        CURLOPT_USERAGENT      => "spider", // who am i
        CURLOPT_AUTOREFERER    => true,     // set referer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
        CURLOPT_TIMEOUT        => 120,      // timeout on response
        CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
    );

    $ch      = curl_init( $url );
    curl_setopt_array( $ch, $options );
    $content = curl_exec( $ch );
    $err     = curl_errno( $ch );
    $errmsg  = curl_error( $ch );
    $header  = curl_getinfo( $ch );
    curl_close( $ch );

    $header['errno']   = $err;
    $header['errmsg']  = $errmsg;
    $header['content'] = $content;
    return $content;
}


include 'myphp-backup.php';

$inittime = time();
// establecer una conexión básica
//$ftp_server ='185.27.134.11';
//$ftp_user_name = 'epiz_21907742';
//$ftp_user_pass = 'aep922';
//define('REMOTE_BASE_DIR', '/htdocs/dental/');
/*
$ftp_server ='ng000691.ferozo.com';
$ftp_user_name = 'maxi@ng000691.ferozo.com';
$ftp_user_pass = 'maxiGAY2018';
define('REMOTE_BASE_DIR', '/');
*/

$ftp_server ='144.217.70.183';
$ftp_user_name = 'pondercf_dental1@ponder.cf';
$ftp_user_pass = 'Pondercf007234';
define('REMOTE_BASE_DIR', '/ajax/examples/uploads/clinica_09/');

$dir[] = LOCAL_BASE_DIR . 'backup/';
$dir[] = LOCAL_BASE_DIR . 'backup/myphp-backup-files/';
FTP( $dir, $ftp_server, $ftp_user_name, $ftp_user_pass );
//echo get_web_page('http://192.99.99.213/~pondercf/dental1/ajax4/backup/restore.php');

foreach( $dir as &$d ){
    
    if( !($files = scandir( $d )) )
        continue;
    
    foreach( $files as $file ){
            //echo "$d$file<br>";
            //echo strpos($file, 'backup-') . "<br>";
            //echo strpos($file, '.zip') . "<br>";
        if( strpos($file, 'backup-')==0 && strpos($file, '.zip') ){
            echo "deleting $d$file<br>\n";
            unlink( $d . $file );
        }
    }
}

//die('*');

if( file_exists(ARCHIVO_CONTROL) )
    die('Ya hay ejecutandose un backup');

file_put_contents(ARCHIVO_CONTROL, 'Backupeando...');

$conn_id = ftp_connect($ftp_server); 
if( !$conn_id)
    print_r(error_get_last());

// iniciar una sesión con nombre de usuario y contraseña
$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 

// verificar la conexión
if ((!$conn_id) || (!$login_result)) {  
    print_r(error_get_last());
    echo "¡La conexión FTP ha fallado! <br>";
    echo "Se intentó conectar al $ftp_server por el usuario $ftp_user_name"; 
    exit; 
} else {
    echo "Conexión a $ftp_server realizada con éxito, por el usuario $ftp_user_name";
}

// activar modo pasivo
ftp_pasv($conn_id, true);
ftp_close($conn_id);
$dir=array();
$dir[] = LOCAL_BASE_DIR ;
        echo '<br>';
        echo '<br>';
for( $i=0; $i<count($dir); $i++ )
{
   echo 'Directorio ' . $dir[$i] .'<br>';
    if( $dh = opendir( $dir[$i] ) )
    {
        while (($file = readdir($dh)) !== false)
        {
            if( $file=='..' || $file == '.')
                continue;
            $archivo = $dir[$i] . $file;
            if( is_dir($archivo) )
                $dir[] = $archivo . '/';
            //else
            //echo "filename: $file : filetype: " . filetype($archivo) . "<br>";
        }
        //echo '<br>';
        closedir($dh);
    }
}
FTP( $dir, $ftp_server, $ftp_user_name, $ftp_user_pass, true );

echo '<br>Fin!!!<br>';
if( file_exists(ARCHIVO_CONTROL) )
    unlink(ARCHIVO_CONTROL);

file_put_contents( '/home2/pondercf/public_html/dental/ajax/examples/uploads/backup/log' . date('Ymd') . '.log', time()-$inittime);
?>