-- phpMyAdmin SQL Dump
-- version 4.0.10.14
-- http://www.phpmyadmin.net
--
-- Servidor: localhost:3306
-- Tiempo de generación: 15-06-2016 a las 06:59:09
-- Versión del servidor: 5.5.50-cll
-- Versión de PHP: 5.4.31

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de datos: `elindelc_nosotros`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=`elindelc`@`localhost` PROCEDURE `actualizar_importes_reservas`(IN `idviaje` INT)
    NO SQL
BEGIN 
	DECLARE idreserva INT DEFAULT 0;
	DECLARE cur CURSOR FOR SELECT id_reserva FROM reserva WHERE id_viaje=idviaje;

	DECLARE CONTINUE HANDLER FOR NOT FOUND SET idreserva=-1;

	OPEN cur;
	FETCH cur INTO idreserva;
	WHILE(idreserva>0) DO
		CALL actualizar_importe_reserva(idreserva);
		FETCH cur INTO idreserva;
	END WHILE;
	CLOSE cur;
END$$

CREATE DEFINER=`elindelc`@`localhost` PROCEDURE `actualizar_importe_reserva`(IN `idreserva` INT)
    NO SQL
BEGIN
	DECLARE suma INT;
	SELECT SUM(precio) INTO suma FROM precio WHERE id_reserva=idreserva;
	IF suma IS NULL THEN
		SET suma=0;
	END IF;
	UPDATE reserva SET total=suma, saldo=suma-pago WHERE id_reserva=idreserva;
END$$

CREATE DEFINER=`elindelc`@`localhost` PROCEDURE `actualizar_saldos_pagos`(IN idreserva INT)
BEGIN
	DECLARE suma INT;
	SELECT SUM(monto) INTO suma FROM pagos WHERE id_reserva=idreserva;
	IF suma IS NULL THEN
		SET suma=0;
	END IF;
	UPDATE reserva SET pago=suma, saldo=total-suma WHERE id_reserva=idreserva;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `bancos`
--

CREATE TABLE IF NOT EXISTS `bancos` (
  `id_bancos` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_bancos`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Volcado de datos para la tabla `bancos`
--

INSERT INTO `bancos` (`id_bancos`, `descripcion`) VALUES
(1, 'ninguno'),
(2, 'credicoop');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cambio`
--

CREATE TABLE IF NOT EXISTS `cambio` (
  `id_moneda` int(11) NOT NULL DEFAULT '0',
  `id_fecha` int(11) NOT NULL DEFAULT '0',
  `pesos` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_moneda`,`id_fecha`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ciudad`
--

CREATE TABLE IF NOT EXISTS `ciudad` (
  `id_ciudad` int(11) NOT NULL AUTO_INCREMENT,
  `id_provincia` int(11) DEFAULT NULL,
  `id_pais` int(11) DEFAULT NULL,
  `descripcion` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_ciudad`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;

--
-- Volcado de datos para la tabla `ciudad`
--

INSERT INTO `ciudad` (`id_ciudad`, `id_provincia`, `id_pais`, `descripcion`) VALUES
(1, 1, 2, 'Rosario'),
(2, 2, 1, 'Bahia blanca'),
(3, 2, 1, 'Mar del Plata'),
(4, 3, 1, 'C&oacute;rdoba'),
(5, 1, 1, 'Santa Fe'),
(7, 1, 1, 'San Lorenzo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `destino`
--

CREATE TABLE IF NOT EXISTS `destino` (
  `id_destino` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(500) NOT NULL,
  PRIMARY KEY (`id_destino`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Volcado de datos para la tabla `destino`
--

INSERT INTO `destino` (`id_destino`, `descripcion`) VALUES
(1, 'DESTINO 1'),
(2, 'DESTINO 2'),
(3, 'DESTINO 3'),
(5, 'DESTINO 4');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_viaje`
--

CREATE TABLE IF NOT EXISTS `detalle_viaje` (
  `id_detalle_viaje` int(11) NOT NULL AUTO_INCREMENT,
  `id_viaje` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_destino` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destino` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_tipo` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_vendedor` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_operador` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_inicio` date DEFAULT NULL,
  `fecha_fin` date DEFAULT NULL,
  `noches` int(100) DEFAULT NULL,
  `importe` decimal(10,2) NOT NULL,
  `id_moneda` int(11) NOT NULL,
  `descripcion` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_detalle_viaje`),
  KEY `id_viaje` (`id_viaje`),
  KEY `id_destino` (`id_destino`),
  KEY `id_tipo` (`id_tipo`),
  KEY `id_vendedor` (`id_vendedor`),
  KEY `id_operador` (`id_operador`),
  KEY `id_moneda` (`id_moneda`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=82 ;

--
-- Volcado de datos para la tabla `detalle_viaje`
--

INSERT INTO `detalle_viaje` (`id_detalle_viaje`, `id_viaje`, `id_destino`, `destino`, `id_tipo`, `id_vendedor`, `id_operador`, `fecha_inicio`, `fecha_fin`, `noches`, `importe`, `id_moneda`, `descripcion`) VALUES
(1, '3', '2', NULL, '1', '1', '1', '2015-12-03', '2016-02-18', 0, '0.00', 0, 'DETALLES'),
(24, '4', '7', NULL, '7', '7', '7', '2016-01-16', '2016-11-02', 0, '0.00', 0, 'viaje 4'),
(26, '2', '1', 'Boston', '1', '1', '2', '2016-05-10', '2016-05-19', 1, '1500.00', 2, 'las que sean'),
(27, '4', 'u', NULL, 'u', '', '', '0000-00-00', '0000-00-00', 0, '0.00', 0, ''),
(29, '1', '1', NULL, '2', '1', '1', '2016-01-01', '2016-01-10', 0, '0.00', 0, 'hotel savoy'),
(30, '1', '2', NULL, '1', '3', '3', '2016-01-14', '2016-01-20', 0, '0.00', 0, 'segundo destino'),
(31, '1', '1', NULL, '1', '1', '3', '2016-01-20', '2016-01-30', 0, '0.00', 0, 'tercer destino'),
(38, '1', '1', NULL, '2', '2', '3', '2016-01-14', '2016-01-02', 0, '0.00', 0, 'detalles cuarto destino'),
(40, '1', '1', NULL, '2', '2', '2', '2016-01-05', '2016-01-14', 0, '0.00', 0, 'otro hotel'),
(41, '4', '1', NULL, '1', '1', '1', '2016-03-03', '2016-03-11', 0, '0.00', 0, ''),
(71, '1', '1', '1', '1', '1', '1', '2016-05-03', '2016-05-03', 1, '0.00', 0, '1'),
(75, '2', '', 'Alabana', '2', '', '2', '2016-05-18', '2016-05-19', 9, '2000.00', 2, 'algunas'),
(77, '2', '', 'New York', '5', '', '1', '2016-05-23', '2016-05-24', 1, '150.00', 1, ''),
(78, '2', '', 'Buenos Aires', '1', '', '1', '2016-05-23', '2016-05-24', 1, '1000.00', 2, ''),
(79, '6', '', 'Primer Destino', '1', '', '1', '2016-05-24', '2016-05-24', 0, '600.00', 1, ''),
(80, '49', '', 'foz do Iguazu', '9', '', '1', '2016-06-22', '2016-06-28', 6, '1000.00', 1, 'Aéreos'),
(81, '49', '', 'foz do iguazu', '2', '', '2', '2016-06-21', '2016-06-28', 7, '400.00', 1, '');

--
-- Disparadores `detalle_viaje`
--
DROP TRIGGER IF EXISTS `detalle_viaje_delete`;
DELIMITER //
CREATE TRIGGER `detalle_viaje_delete` AFTER DELETE ON `detalle_viaje`
 FOR EACH ROW BEGIN

DELETE p FROM precio p LEFT JOIN reserva r ON p.id_reserva=r.id_reserva 
	WHERE p.id_detalle_viaje=OLD.id_detalle_viaje AND r.id_viaje=OLD.id_viaje;


CALL actualizar_importes_reservas(OLD.id_viaje);

END
//
DELIMITER ;
DROP TRIGGER IF EXISTS `detalle_viaje_insert`;
DELIMITER //
CREATE TRIGGER `detalle_viaje_insert` AFTER INSERT ON `detalle_viaje`
 FOR EACH ROW BEGIN

INSERT INTO `precio`(`id_reserva`, `id_persona`, `id_detalle_viaje`, `precio`, `id_moneda`)
	SELECT r.id_reserva, p.id_persona, NEW.id_detalle_viaje, NEW.importe, NEW.id_moneda
	FROM reserva r, persona_reserva p
	WHERE r.id_viaje=NEW.id_viaje AND p.id_reserva=r.id_reserva;

CALL actualizar_importes_reservas(NEW.id_viaje);

END
//
DELIMITER ;
DROP TRIGGER IF EXISTS `detalle_viaje_update`;
DELIMITER //
CREATE TRIGGER `detalle_viaje_update` AFTER UPDATE ON `detalle_viaje`
 FOR EACH ROW CALL actualizar_importes_reservas(NEW.id_viaje)
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `documentac`
--

CREATE TABLE IF NOT EXISTS `documentac` (
  `id_documentac` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  `observa` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_documentac`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;

--
-- Volcado de datos para la tabla `documentac`
--

INSERT INTO `documentac` (`id_documentac`, `descripcion`, `observa`) VALUES
(1, 'DNI en buen estado\n\n', 'observaciones 1'),
(2, 'Vacuna', 'observaciones 2'),
(3, 'VISA DE USA', 'observaciones 3'),
(5, 'Documentación Requerida 4', 'observaciones 4'),
(6, 'Documentación Requerida 5', 'observaciones 5');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `documentacion_persona`
--

CREATE TABLE IF NOT EXISTS `documentacion_persona` (
  `id_documentacion_persona` int(11) NOT NULL AUTO_INCREMENT,
  `id_viaje` int(11) NOT NULL,
  `id_persona` int(11) NOT NULL,
  `id_documentac` int(11) NOT NULL,
  `observa` varchar(250) NOT NULL,
  `archivo` varchar(250) NOT NULL,
  PRIMARY KEY (`id_documentacion_persona`),
  KEY `id_viaje` (`id_viaje`),
  KEY `id_persona` (`id_persona`),
  KEY `id_documentac` (`id_documentac`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=44 ;

--
-- Volcado de datos para la tabla `documentacion_persona`
--

INSERT INTO `documentacion_persona` (`id_documentacion_persona`, `id_viaje`, `id_persona`, `id_documentac`, `observa`, `archivo`) VALUES
(1, 2, 2, 1, 'zzzz', ''),
(2, 2, 6, 1, 'aaa', ''),
(3, 2, 1, 1, 'zzzz', ''),
(4, 2, 4, 1, 'zzzz', ''),
(6, 2, 2, 2, 'zzzz', ''),
(7, 2, 6, 2, 'zzzz11', ''),
(8, 2, 1, 2, 'zzzz', ''),
(9, 2, 4, 2, 'zzzz', ''),
(11, 2, 2, 3, 'zzzz', ''),
(12, 2, 6, 3, 'zzzz', ''),
(13, 2, 1, 3, 'zzzz', ''),
(14, 2, 4, 3, 'zzzz', ''),
(16, 6, 15, 1, '', ''),
(17, 6, 15, 2, '', ''),
(19, 2, 16, 1, '', ''),
(20, 2, 16, 2, '', ''),
(21, 2, 16, 3, '', ''),
(22, 2, 3, 1, '', ''),
(23, 2, 3, 2, '', ''),
(24, 2, 3, 3, '', ''),
(27, 49, 18, 1, '', ''),
(29, 49, 20, 1, '', ''),
(30, 49, 21, 1, '', ''),
(41, 2, 23, 1, '', ''),
(42, 2, 23, 2, '', ''),
(43, 2, 23, 3, '', '');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `documentac_viaje`
--

CREATE TABLE IF NOT EXISTS `documentac_viaje` (
  `id_documentac_viaje` int(11) NOT NULL AUTO_INCREMENT,
  `id_viaje` int(11) DEFAULT NULL,
  `id_documentac` int(11) DEFAULT NULL,
  `observa` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_documentac_viaje`),
  KEY `id_viaje` (`id_viaje`),
  KEY `id_documentac` (`id_documentac`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=38 ;

--
-- Volcado de datos para la tabla `documentac_viaje`
--

INSERT INTO `documentac_viaje` (`id_documentac_viaje`, `id_viaje`, `id_documentac`, `observa`) VALUES
(2, 3, 2, 'Observación 222'),
(3, 1, 1, 'Observaciones 1111'),
(4, 4, 3, 'obvserva 3'),
(5, 0, 5, ''),
(19, 6, 1, ''),
(21, 6, 2, ''),
(34, 2, 1, ''),
(35, 2, 2, ''),
(36, 2, 3, ''),
(37, 49, 1, '');

--
-- Disparadores `documentac_viaje`
--
DROP TRIGGER IF EXISTS `documentac_viaje_delete`;
DELIMITER //
CREATE TRIGGER `documentac_viaje_delete` AFTER DELETE ON `documentac_viaje`
 FOR EACH ROW DELETE FROM documentacion_persona WHERE id_viaje=OLD.id_viaje AND id_documentac=OLD.id_documentac
//
DELIMITER ;
DROP TRIGGER IF EXISTS `documentac_viaje_insert`;
DELIMITER //
CREATE TRIGGER `documentac_viaje_insert` AFTER INSERT ON `documentac_viaje`
 FOR EACH ROW INSERT INTO `documentacion_persona`(`id_viaje`, `id_persona`, `id_documentac`) 
SELECT NEW.id_viaje, p.id_persona, NEW.id_documentac
FROM reserva r, persona_reserva p
WHERE r.id_viaje=NEW.id_viaje AND p.id_reserva=r.id_reserva
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `facturas`
--

CREATE TABLE IF NOT EXISTS `facturas` (
  `id_facturas` int(11) NOT NULL AUTO_INCREMENT,
  `id_reserva` varchar(11) DEFAULT NULL,
  `id_persona` varchar(11) DEFAULT NULL,
  `id_moneda` varchar(11) DEFAULT NULL,
  `fecha` date NOT NULL,
  `num_factura` varchar(11) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_facturas`),
  KEY `id_reserva` (`id_reserva`),
  KEY `id_persona` (`id_persona`),
  KEY `id_moneda` (`id_moneda`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `impuesto`
--

CREATE TABLE IF NOT EXISTS `impuesto` (
  `id_impuesto` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_impuesto`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Volcado de datos para la tabla `impuesto`
--

INSERT INTO `impuesto` (`id_impuesto`, `descripcion`) VALUES
(1, 'Impuesto 1'),
(2, 'Impuesto 2'),
(3, 'Impuesto 3');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ingreso`
--

CREATE TABLE IF NOT EXISTS `ingreso` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pass` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Volcado de datos para la tabla `ingreso`
--

INSERT INTO `ingreso` (`id_user`, `user`, `pass`, `nombre`, `empresa`) VALUES
(1, 'vane', 'vane', 'Vanesa', 'empresa_00');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `moneda`
--

CREATE TABLE IF NOT EXISTS `moneda` (
  `id_moneda` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_moneda`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Volcado de datos para la tabla `moneda`
--

INSERT INTO `moneda` (`id_moneda`, `descripcion`) VALUES
(1, '$Ar'),
(2, 'U$S'),
(3, 'EUR'),
(5, 'YEN');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `operador`
--

CREATE TABLE IF NOT EXISTS `operador` (
  `id_operador` int(11) NOT NULL AUTO_INCREMENT,
  `razon` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domicilio` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tel` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `celu` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ciudad` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pcia` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pais` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_operador`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Volcado de datos para la tabla `operador`
--

INSERT INTO `operador` (`id_operador`, `razon`, `domicilio`, `tel`, `celu`, `mail`, `ciudad`, `pcia`, `pais`) VALUES
(1, 'OLA', 'domicilio operador 1', '341-111111 / 346-111111', '155111111', 'email@uno.com', '1', 'Santa fe', '1'),
(2, 'FREE WAY', 'domicilio operador 2', '341-222222 / 346-222222', '155222222', 'email@dos.com', '2', 'Buenos aires', '2'),
(3, 'ABANICO', 'domicilio operador 3', '341-333333 / 346-333333', '155333333', 'email@tres.com', '1', 'Santa Fe', '1'),
(4, 'RAPEL', 'domicilio operador 4', '341-444444 / 346-444444', '155444444', 'email@cuatro.net', '3', 'Buenos Aires', '1');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pagos`
--

CREATE TABLE IF NOT EXISTS `pagos` (
  `id_pago` int(11) NOT NULL AUTO_INCREMENT,
  `id_reserva` int(11) DEFAULT NULL,
  `id_tipo_pago` int(11) DEFAULT NULL,
  `id_tarjeta` int(11) DEFAULT NULL,
  `id_bancos` int(11) DEFAULT NULL,
  `num_tarjeta` varchar(22) DEFAULT NULL,
  `cuotas` int(5) DEFAULT NULL,
  `fecha_pago` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `monto` decimal(10,2) DEFAULT NULL,
  `id_moneda` int(11) DEFAULT NULL,
  `observa` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_pago`),
  KEY `id_reserva` (`id_reserva`),
  KEY `id_tipo_pago` (`id_tipo_pago`),
  KEY `id_tarjeta` (`id_tarjeta`),
  KEY `id_bancos` (`id_bancos`),
  KEY `id_moneda` (`id_moneda`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=25 ;

--
-- Volcado de datos para la tabla `pagos`
--

INSERT INTO `pagos` (`id_pago`, `id_reserva`, `id_tipo_pago`, `id_tarjeta`, `id_bancos`, `num_tarjeta`, `cuotas`, `fecha_pago`, `fecha_cobro`, `monto`, `id_moneda`, `observa`) VALUES
(1, 1, 2, NULL, NULL, NULL, NULL, '2016-01-08', NULL, '112.00', 2, NULL),
(2, 1, 4, NULL, NULL, NULL, NULL, '2016-01-15', NULL, '333.00', 3, NULL),
(3, 1, 5, NULL, NULL, NULL, NULL, '2016-01-08', NULL, '555.00', 1, 'algunas observaciones'),
(4, 2, 1, 1, 2, '', NULL, '2016-01-08', '2016-01-30', '777.00', 1, 'primer pago'),
(5, 2, 3, 1, 1, '', NULL, '2016-01-08', '2016-01-21', '781.00', 2, 'ninguna observación ninguna'),
(6, 2, 4, 1, 1, '', NULL, '2016-02-12', '2016-01-22', '897.00', 1, 'observaciones'),
(7, 2, 4, 1, 1, '', NULL, '2016-01-07', '2016-01-02', '999.00', 1, 'algunas'),
(8, 2, 2, 1, 1, '1234567890123456789012', 2, '2016-01-22', '2016-01-01', '333.00', 1, 'nuevas'),
(9, 2, 2, 1, 1, '2153264857952458165748', 1, '2016-01-08', '2016-01-08', '777.00', 1, ''),
(10, 2, 2, 1, 1, '2153264857952458165748', 11, '2016-01-20', '2016-01-07', '999.00', 1, ''),
(11, 2, 2, 1, 1, '2153264857952458165748', 4, '2016-01-13', '2016-01-29', '569.00', 3, ''),
(16, 17, 1, 1, 2, '', 0, '0000-00-00', '0000-00-00', '0.00', 1, ''),
(20, 17, 1, 1, 1, '', 0, '0000-00-00', '0000-00-00', '123.00', 1, ''),
(21, 11, 4, 1, 1, '', 0, '2016-05-18', '0000-00-00', '250.00', 1, ''),
(22, 11, 4, 1, 1, '', 0, '2016-05-18', '0000-00-00', '300.00', 1, ''),
(23, 5, 1, 1, 2, '', 0, '0000-00-00', '0000-00-00', '150.00', 1, ''),
(24, 41, 4, 1, 1, '', 0, '2016-06-09', '0000-00-00', '500.00', 1, '');

--
-- Disparadores `pagos`
--
DROP TRIGGER IF EXISTS `actualizar_pagos_delete`;
DELIMITER //
CREATE TRIGGER `actualizar_pagos_delete` AFTER DELETE ON `pagos`
 FOR EACH ROW CALL actualizar_saldos_pagos(OLD.id_reserva)
//
DELIMITER ;
DROP TRIGGER IF EXISTS `actualizar_pagos_insert`;
DELIMITER //
CREATE TRIGGER `actualizar_pagos_insert` AFTER INSERT ON `pagos`
 FOR EACH ROW CALL actualizar_saldos_pagos(NEW.id_reserva)
//
DELIMITER ;
DROP TRIGGER IF EXISTS `actualizar_pagos_update`;
DELIMITER //
CREATE TRIGGER `actualizar_pagos_update` AFTER UPDATE ON `pagos`
 FOR EACH ROW CALL actualizar_saldos_pagos(OLD.id_reserva)
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pagos_cheques`
--

CREATE TABLE IF NOT EXISTS `pagos_cheques` (
  `id_pagos_cheques` int(11) NOT NULL AUTO_INCREMENT,
  `id_banco` varchar(11) DEFAULT NULL,
  `fecha_cobro` date NOT NULL,
  `otros_datos` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_pagos_cheques`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pagos_t_cred`
--

CREATE TABLE IF NOT EXISTS `pagos_t_cred` (
  `id_pago_t_cred` int(11) NOT NULL AUTO_INCREMENT,
  `id_pago` varchar(11) DEFAULT NULL,
  `id_tarjeta` varchar(11) DEFAULT NULL,
  `id_banco` varchar(11) DEFAULT NULL,
  `num_tarj` varchar(11) DEFAULT NULL,
  `cuotas` varchar(11) DEFAULT NULL,
  `otros_datos` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_pago_t_cred`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pagos_t_deb`
--

CREATE TABLE IF NOT EXISTS `pagos_t_deb` (
  `id_pagos_t_deb` int(11) NOT NULL AUTO_INCREMENT,
  `id_pago` varchar(11) DEFAULT NULL,
  `id_tarjeta` varchar(11) DEFAULT NULL,
  `id_banco` varchar(11) DEFAULT NULL,
  `otros_datos` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_pagos_t_deb`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pais`
--

CREATE TABLE IF NOT EXISTS `pais` (
  `id_pais` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_pais`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Volcado de datos para la tabla `pais`
--

INSERT INTO `pais` (`id_pais`, `descripcion`) VALUES
(1, 'Argentina'),
(2, 'Brasil');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `persona`
--

CREATE TABLE IF NOT EXISTS `persona` (
  `id_persona` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_doc` int(11) DEFAULT NULL,
  `documento` varchar(11) CHARACTER SET latin1 DEFAULT NULL,
  `nombre` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `apellido` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `fecha_nac` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `nacionalidad` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `domicilio` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `id_ciudad` int(11) DEFAULT NULL,
  `tel` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `celu` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `mail` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id_persona`),
  KEY `id_ciudad` (`id_ciudad`),
  KEY `id_tipo_doc` (`id_tipo_doc`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci AUTO_INCREMENT=24 ;

--
-- Volcado de datos para la tabla `persona`
--

INSERT INTO `persona` (`id_persona`, `id_tipo_doc`, `documento`, `nombre`, `apellido`, `fecha_nac`, `nacionalidad`, `domicilio`, `id_ciudad`, `tel`, `celu`, `mail`) VALUES
(1, 1, '211112', 'Juan Niño', 'Amenábar', NULL, NULL, 'La Madrid 786 1er Piso 1', 4, '03456 4587965', '3416582459', 'email@pasajero.uno'),
(2, 4, '222222', 'Leónidas', 'Bracalentti', NULL, NULL, 'Sarmiento 233 2° Piso 2', 2, '0564 7854976', '0358952148', 'email@pasajero.dos'),
(3, 1, '233333', 'Ana Clara', 'Constantini', NULL, NULL, 'Av. San Martí­n 456', 1, '0256 5487521', '3425897546', 'email@pasajero.tres'),
(4, 1, '244444', 'Francisca Daniela', 'Dédalo', NULL, NULL, 'Uriburu 9879 Piso 4 Dto B', 1, '02543 4215875', '3254125489', 'email@pasajero.cuatro'),
(6, 1, '255555', 'Lorena', 'Koestler', NULL, NULL, 'Whashington 545 Piso 5', 2, '05264 8975486', '3562145875', 'email@pasajero.cinco11'),
(7, 1, '2666775', 'Alejandro', 'Zanetti', NULL, NULL, 'El Jilguero 345', 4, '0341 4589625', '1568795483', 'email@pasajero.seis'),
(8, 1, '243423', 'Lucrecia', 'Vivache', NULL, NULL, 'Koeler 342', 3, '423423', '4525234234', 'mail@lorena.com'),
(9, 1, '23523452', 'Marcelo', 'Rabin', NULL, NULL, 'Lapataia 786', 4, '3523452345', '35424235424', 'marcelo@email.com'),
(13, 1, '1333333', 'pepe', 'pepe', NULL, NULL, 'e', 1, 'e', 'e', 'email@pasajero.tres'),
(14, 1, '1222222', 'Gabriela', 'Andes', NULL, NULL, '3', 1, '3', '', '3'),
(16, 1, '32159123', 'Juan Manual', 'Cossa', NULL, NULL, '*', 1, '*', '*', '*'),
(17, 1, '32704000', 'Juan', 'Perez', NULL, NULL, 'san lorenzo 1262', 1, '00', '00', ''),
(18, 1, '3333333', 'Leonarda', 'LÃ³pez', NULL, NULL, 'Viamonte 231', 1, '', '', ''),
(19, 1, '4444444', 'AndrÃƒÂ©s', 'PagaÃƒÂ±ini', NULL, NULL, 'ValentÃƒÂ­n GÃƒÂ³mez 899', 1, '', '', ''),
(20, 1, '8888888', 'DaÃ±iel', 'ÃngÃºs', NULL, NULL, 'YÃ¡Ã±ez 999', 1, '', '', ''),
(21, 1, '9898988', 'KÃ¡rem', 'Ã‰xodus', NULL, NULL, 'KÃ©plar 2323', 1, '', '', ''),
(22, 1, '1111111', 'Andrés', 'Añañael', NULL, NULL, 'pipi 9898', 1, '', '', ''),
(23, 1, '111111111', 'Ã‘ancÃº', 'GÃ¼arango', NULL, NULL, 'Ã‘Ã­Ã±Ã³Ã±Ãº', 1, '12', '12', '12');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `persona_reserva`
--

CREATE TABLE IF NOT EXISTS `persona_reserva` (
  `id_persona_reserva` int(11) NOT NULL AUTO_INCREMENT,
  `id_reserva` int(11) DEFAULT NULL,
  `id_viaje` int(11) DEFAULT NULL,
  `id_persona` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `precio` varchar(11) DEFAULT NULL,
  `id_moneda` varchar(5) DEFAULT NULL,
  `observa` varchar(350) DEFAULT NULL,
  `id_factura` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_persona_reserva`),
  KEY `id_reserva` (`id_reserva`),
  KEY `id_viaje` (`id_viaje`),
  KEY `id_persona` (`id_persona`),
  KEY `id_moneda` (`id_moneda`),
  KEY `id_factura` (`id_factura`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=72 ;

--
-- Volcado de datos para la tabla `persona_reserva`
--

INSERT INTO `persona_reserva` (`id_persona_reserva`, `id_reserva`, `id_viaje`, `id_persona`, `fecha`, `precio`, `id_moneda`, `observa`, `id_factura`) VALUES
(1, 1, 2, 7, '2016-02-23', '111', '1', '', 0),
(3, 2, 2, 4, '2016-02-24', '', '1', '', 0),
(4, 2, 2, 1, '2016-02-27', '', '1', '', 0),
(8, 7, 25, 8, '2016-02-26', '230', '2', 'observa', 0),
(9, 7, 25, 7, '2016-02-27', '230', '2', 'observa', 0),
(11, 4, 4, 2, '2016-03-10', '44', '1', '', 0),
(13, 13, 2, 2, '2016-03-10', '', '1', '', 0),
(15, 12, 2, 6, '2016-03-25', '', '1', '', 0),
(16, 15, 25, 1, '2016-03-11', '', '1', '', 0),
(20, 17, 1, 1, NULL, NULL, NULL, NULL, NULL),
(35, 17, 0, 7, '0000-00-00', '', '', '', 0),
(40, 12, 0, 1, '0000-00-00', '', '', '', 0),
(42, 13, 0, 4, '0000-00-00', '', '', '', 0),
(47, 17, NULL, 3, NULL, NULL, NULL, '', NULL),
(48, 17, NULL, 13, NULL, NULL, NULL, '4444', NULL),
(53, 5, NULL, 3, NULL, NULL, NULL, '', NULL),
(54, 40, NULL, 15, NULL, NULL, NULL, '', NULL),
(55, 14, NULL, 16, NULL, NULL, NULL, '*', NULL),
(56, 11, NULL, 3, NULL, NULL, NULL, '', NULL),
(59, 41, NULL, 18, NULL, NULL, NULL, '', NULL),
(60, 41, NULL, 6, NULL, NULL, NULL, '', NULL),
(61, 41, NULL, 20, NULL, NULL, NULL, '', NULL),
(62, 41, NULL, 21, NULL, NULL, NULL, '', NULL),
(71, 11, NULL, 23, NULL, NULL, NULL, '', NULL);

--
-- Disparadores `persona_reserva`
--
DROP TRIGGER IF EXISTS `calcular_personas_delete`;
DELIMITER //
CREATE TRIGGER `calcular_personas_delete` AFTER DELETE ON `persona_reserva`
 FOR EACH ROW BEGIN
DECLARE idviaje INT;

UPDATE reserva SET cant_pasaj = ((SELECT COUNT(*) FROM `persona_reserva` WHERE id_reserva=OLD.id_reserva)+1) WHERE id_reserva=OLD.id_reserva;

SELECT id_viaje INTO idviaje FROM reserva WHERE id_reserva=OLD.id_reserva;

DELETE FROM documentacion_persona WHERE id_viaje=idviaje AND id_persona=OLD.id_persona;

DELETE FROM precio WHERE id_reserva=OLD.id_reserva AND id_persona=OLD.id_persona;


CALL actualizar_importe_reserva(OLD.id_reserva);
END
//
DELIMITER ;
DROP TRIGGER IF EXISTS `calcular_personas_insert`;
DELIMITER //
CREATE TRIGGER `calcular_personas_insert` AFTER INSERT ON `persona_reserva`
 FOR EACH ROW BEGIN

UPDATE reserva SET cant_pasaj = ((SELECT COUNT(*) FROM `persona_reserva` WHERE id_reserva=NEW.id_reserva)+1) WHERE id_reserva=NEW.id_reserva;

INSERT INTO `documentacion_persona`(`id_viaje`, `id_persona`, `id_documentac`) 
	SELECT r.id_viaje, NEW.id_persona, d.id_documentac 
	FROM reserva r, documentac_viaje d
	WHERE r.id_reserva=NEW.id_reserva AND r.id_viaje=d.id_viaje;

INSERT INTO `precio`(`id_reserva`, `id_persona`, `id_detalle_viaje`, `precio`, `id_moneda`)
	SELECT r.id_reserva, NEW.id_persona, d.id_detalle_viaje, d.importe, d.id_moneda
	FROM reserva r, detalle_viaje d
	WHERE r.id_reserva=NEW.id_reserva AND r.id_viaje=d.id_viaje;

CALL actualizar_importe_reserva(NEW.id_reserva);
END
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `precio`
--

CREATE TABLE IF NOT EXISTS `precio` (
  `id_precio` int(11) NOT NULL AUTO_INCREMENT,
  `id_reserva` int(11) DEFAULT NULL,
  `id_persona` int(11) DEFAULT NULL,
  `id_detalle_viaje` int(11) NOT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `id_moneda` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_precio`),
  KEY `id_reserva` (`id_reserva`),
  KEY `id_persona` (`id_persona`),
  KEY `id_detalle_viaje` (`id_detalle_viaje`),
  KEY `id_moneda` (`id_moneda`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=90 ;

--
-- Volcado de datos para la tabla `precio`
--

INSERT INTO `precio` (`id_precio`, `id_reserva`, `id_persona`, `id_detalle_viaje`, `precio`, `id_moneda`) VALUES
(12, 13, 2, 77, '123.00', 1),
(13, 12, 6, 77, '123.00', 1),
(14, 12, 1, 77, '123.00', 1),
(15, 13, 4, 77, '123.00', 1),
(19, 13, 2, 78, '200.00', 1),
(20, 12, 6, 78, '200.00', 1),
(21, 12, 1, 78, '200.00', 1),
(22, 13, 4, 78, '200.00', 1),
(24, 5, 3, 79, '610.00', 1),
(25, 40, 15, 79, '600.00', 1),
(26, 14, 16, 26, '1000.00', 2),
(27, 14, 16, 75, '2000.00', 2),
(28, 14, 16, 77, '150.00', 1),
(29, 14, 16, 78, '1000.00', 2),
(33, 11, 3, 26, '1600.00', 2),
(34, 11, 3, 75, '2000.00', 2),
(35, 11, 3, 77, '150.00', 1),
(36, 11, 3, 78, '1000.00', 2),
(43, 41, 18, 80, '1000.00', 1),
(44, 41, 18, 81, '400.00', 1),
(49, 41, 20, 80, '1000.00', 1),
(50, 41, 20, 81, '400.00', 1),
(52, 41, 21, 80, '1000.00', 1),
(53, 41, 21, 81, '400.00', 1),
(83, 11, 23, 26, '1500.00', 2),
(84, 11, 23, 75, '2000.00', 2),
(85, 11, 23, 77, '150.00', 1),
(86, 11, 23, 78, '1000.00', 2);

--
-- Disparadores `precio`
--
DROP TRIGGER IF EXISTS `precio_update`;
DELIMITER //
CREATE TRIGGER `precio_update` AFTER UPDATE ON `precio`
 FOR EACH ROW CALL actualizar_importe_reserva(NEW.id_reserva)
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `provincia`
--

CREATE TABLE IF NOT EXISTS `provincia` (
  `id_provincia` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_provincia`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Volcado de datos para la tabla `provincia`
--

INSERT INTO `provincia` (`id_provincia`, `descripcion`) VALUES
(1, 'Santa fe'),
(2, 'Buenos aires'),
(3, 'Córdoba'),
(5, 'Entre Ríos');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `reserva`
--

CREATE TABLE IF NOT EXISTS `reserva` (
  `id_reserva` int(11) NOT NULL AUTO_INCREMENT,
  `id_viaje` int(11) DEFAULT NULL,
  `id_persona` int(11) DEFAULT NULL,
  `cant_pasaj` int(11) DEFAULT '0',
  `fecha_reserva` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `pago` decimal(10,2) DEFAULT NULL,
  `saldo` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_reserva`),
  KEY `id_viaje` (`id_viaje`),
  KEY `id_persona` (`id_persona`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=42 ;

--
-- Volcado de datos para la tabla `reserva`
--

INSERT INTO `reserva` (`id_reserva`, `id_viaje`, `id_persona`, `cant_pasaj`, `fecha_reserva`, `total`, `pago`, `saldo`) VALUES
(3, 3, 4, 0, '2016-02-24', '0.00', '0.00', '0.00'),
(4, 4, 2, 0, '2016-02-25', '0.00', '0.00', '0.00'),
(5, 6, 1, 1, '2016-02-26', '610.00', '150.00', '460.00'),
(7, 25, 8, 0, '2016-02-25', '0.00', '0.00', '0.00'),
(10, 4, 2, 0, '2016-03-17', '0.00', '0.00', '0.00'),
(11, 2, 3, 3, '2016-03-26', '9400.00', '550.00', '8850.00'),
(12, 2, 1, 2, '2016-03-26', '646.00', '0.00', '646.00'),
(13, 2, 6, 2, '2016-03-26', '646.00', '0.00', '646.00'),
(14, 2, 4, 1, '2016-03-18', '4150.00', '0.00', '4150.00'),
(15, 25, 1, 0, '2016-03-25', '0.00', '0.00', '0.00'),
(17, 1, 9, 4, '2016-03-31', '0.00', '0.00', '0.00'),
(28, 25, 4, 0, '2016-03-24', '0.00', '0.00', '0.00'),
(40, 6, 12, 1, '2016-01-23', '600.00', '0.00', '600.00'),
(41, 49, 17, 5, '2016-06-09', '4200.00', '500.00', '3700.00');

--
-- Disparadores `reserva`
--
DROP TRIGGER IF EXISTS `calcular_personas_update`;
DELIMITER //
CREATE TRIGGER `calcular_personas_update` AFTER UPDATE ON `reserva`
 FOR EACH ROW UPDATE viajes SET cant_pasajeros = (SELECT SUM(cant_pasaj) FROM `reserva` WHERE id_viaje=OLD.id_viaje) WHERE id_viaje=OLD.id_viaje
//
DELIMITER ;
DROP TRIGGER IF EXISTS `calcular_reservas_delete`;
DELIMITER //
CREATE TRIGGER `calcular_reservas_delete` AFTER DELETE ON `reserva`
 FOR EACH ROW UPDATE viajes SET cant_reservas = (SELECT COUNT(*) FROM `reserva` WHERE id_viaje=OLD.id_viaje) WHERE id_viaje=OLD.id_viaje
//
DELIMITER ;
DROP TRIGGER IF EXISTS `calcular_reservas_insert`;
DELIMITER //
CREATE TRIGGER `calcular_reservas_insert` AFTER INSERT ON `reserva`
 FOR EACH ROW UPDATE viajes SET cant_reservas = (SELECT COUNT(*) FROM `reserva` WHERE id_viaje=NEW.id_viaje) WHERE id_viaje=NEW.id_viaje
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `resumen_precios`
--
CREATE TABLE IF NOT EXISTS `resumen_precios` (
`id_precio` int(11)
,`id_reserva` int(11)
,`id_persona` int(11)
,`destino` varchar(300)
,`id_tipo` varchar(11)
,`fecha_inicio` date
,`fecha_fin` date
,`importe` decimal(10,2)
,`id_moneda1` int(11)
,`precio` decimal(10,2)
,`id_moneda` int(11)
);
-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tarjetas`
--

CREATE TABLE IF NOT EXISTS `tarjetas` (
  `id_tarjeta` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_tarjeta`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Volcado de datos para la tabla `tarjetas`
--

INSERT INTO `tarjetas` (`id_tarjeta`, `descripcion`) VALUES
(1, 'ninguna'),
(2, 'master');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tasa`
--

CREATE TABLE IF NOT EXISTS `tasa` (
  `id_tasa` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo` int(11) DEFAULT NULL,
  `id_impuesto` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `descripcion` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_tasa`),
  KEY `id_tipo` (`id_tipo`),
  KEY `id_impuesto` (`id_impuesto`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=20 ;

--
-- Volcado de datos para la tabla `tasa`
--

INSERT INTO `tasa` (`id_tasa`, `id_tipo`, `id_impuesto`, `fecha`, `descripcion`) VALUES
(1, 1, 2, '2016-01-19', '20.00'),
(2, 2, 2, '2016-01-01', '21.00'),
(4, 2, 1, '2016-02-02', '5.00'),
(15, 2, 1, '2016-02-04', '22.00'),
(16, 1, 2, '2016-03-25', '15.00'),
(17, 1, 1, '2016-03-01', '11.00'),
(18, 2, 3, '2016-03-03', '33.00'),
(19, 5, 2, '2016-03-02', '222.00');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tasa_cambio`
--

CREATE TABLE IF NOT EXISTS `tasa_cambio` (
  `id_tasa_cambio` int(11) NOT NULL AUTO_INCREMENT,
  `id_moneda` varchar(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `pesos` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_tasa_cambio`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Volcado de datos para la tabla `tasa_cambio`
--

INSERT INTO `tasa_cambio` (`id_tasa_cambio`, `id_moneda`, `fecha`, `pesos`) VALUES
(1, '2', '2016-02-08', '14.00'),
(2, '1', '2016-02-04', '99.00'),
(3, '1', '2016-03-11', '11.00'),
(5, '2', '2016-05-04', '16.00');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo`
--

CREATE TABLE IF NOT EXISTS `tipo` (
  `id_tipo` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id_tipo`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;

--
-- Volcado de datos para la tabla `tipo`
--

INSERT INTO `tipo` (`id_tipo`, `descripcion`) VALUES
(1, 'Pasaje Aéreo'),
(2, 'Hotelería'),
(5, 'Tren í'),
(6, 'Crucero'),
(7, 'Traslado'),
(8, 'Bus'),
(9, 'Aéreo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_doc`
--

CREATE TABLE IF NOT EXISTS `tipo_doc` (
  `id_tipo_doc` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id_tipo_doc`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Volcado de datos para la tabla `tipo_doc`
--

INSERT INTO `tipo_doc` (`id_tipo_doc`, `descripcion`) VALUES
(1, 'dni'),
(4, 'pasaporte');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_pago`
--

CREATE TABLE IF NOT EXISTS `tipo_pago` (
  `id_tipo_pago` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_tipo_pago`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;

--
-- Volcado de datos para la tabla `tipo_pago`
--

INSERT INTO `tipo_pago` (`id_tipo_pago`, `descripcion`) VALUES
(1, 'Tarjeta Débito'),
(2, 'Tarjeta Crédito'),
(3, 'Cheque'),
(4, 'Efectivo'),
(5, 'Transferencia Bancaria'),
(6, 'Paypal');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `vendedor`
--

CREATE TABLE IF NOT EXISTS `vendedor` (
  `id_vendedor` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id_vendedor`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Volcado de datos para la tabla `vendedor`
--

INSERT INTO `vendedor` (`id_vendedor`, `descripcion`) VALUES
(1, 'VENDEDOR 1'),
(2, 'VENDEDOR 2'),
(3, 'VENDEDOR 3'),
(4, 'VENDEDOR 4');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `viajes`
--

CREATE TABLE IF NOT EXISTS `viajes` (
  `id_viaje` int(11) NOT NULL AUTO_INCREMENT,
  `detalle` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vendedor` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `fecha_llegada` date DEFAULT NULL,
  `cant_reservas` int(11) DEFAULT NULL,
  `cant_pasajeros` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_viaje`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=50 ;

--
-- Volcado de datos para la tabla `viajes`
--

INSERT INTO `viajes` (`id_viaje`, `detalle`, `vendedor`, `fecha`, `fecha_llegada`, `cant_reservas`, `cant_pasajeros`) VALUES
(1, 'Barcelona', '', '2016-01-20', '2016-05-11', 1, 4),
(2, 'Estados Unidos', '', '2016-06-29', '2016-07-20', 4, 8),
(3, 'Perú', '', '2016-02-09', '2016-04-22', 1, 0),
(4, 'Alemania y Francia', '', '2016-03-07', '2016-04-22', 2, 0),
(6, '<font style=''color:red''>Bagdad1</font>', '', '2016-04-27', '2016-04-27', 2, 2),
(8, 'Los Angeles', '', '2016-01-20', '2016-04-22', 0, 0),
(9, 'Madrid', '', '2016-01-22', '2016-04-22', 0, 0),
(11, 'México', '', '2016-01-20', '2016-04-22', 0, 0),
(25, 'España', '', '2016-03-17', '2016-04-01', 3, 0),
(26, 'Italia', '', '2016-02-24', '2016-03-25', 0, 0),
(28, 'Venezuela', '', '2016-02-26', '2016-03-24', 0, 0),
(43, 'Estocolmo', '', '2016-03-31', '2016-04-15', 0, 0),
(46, '22323', '', '2016-04-06', '2016-04-07', 0, 0),
(47, 'Mar del Plata', '', '2016-05-19', '2016-05-26', 0, 0),
(49, 'foz do Iguazú', 'Mari', '2016-06-22', '2016-06-28', 1, 5);

-- --------------------------------------------------------

--
-- Estructura para la vista `resumen_precios`
--
DROP TABLE IF EXISTS `resumen_precios`;

CREATE ALGORITHM=UNDEFINED DEFINER=`elindelc`@`localhost` SQL SECURITY DEFINER VIEW `resumen_precios` AS select `p`.`id_precio` AS `id_precio`,`p`.`id_reserva` AS `id_reserva`,`p`.`id_persona` AS `id_persona`,`d`.`destino` AS `destino`,`d`.`id_tipo` AS `id_tipo`,`d`.`fecha_inicio` AS `fecha_inicio`,`d`.`fecha_fin` AS `fecha_fin`,`d`.`importe` AS `importe`,`d`.`id_moneda` AS `id_moneda1`,`p`.`precio` AS `precio`,`p`.`id_moneda` AS `id_moneda` from (`precio` `p` join `detalle_viaje` `d`) where (`p`.`id_detalle_viaje` = `d`.`id_detalle_viaje`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
