<?php

function eliminar_tildes($cadena){
    //Codificamos la cadena en formato utf8 en caso de que nos de errores
    $cadena = utf8_encode($cadena);
    //Ahora reemplazamos las letras
    $cadena = str_replace(
        array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
        array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
        $cadena
    );
    $cadena = str_replace(
        array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
        array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
        $cadena );
    $cadena = str_replace(
        array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
        array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
        $cadena );
    $cadena = str_replace(
        array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
        array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
        $cadena );
    $cadena = str_replace(
        array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
        array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
        $cadena );
    $cadena = str_replace(
        array('ñ', 'Ñ', 'ç', 'Ç'),
        array('n', 'N', 'c', 'C'),
        $cadena
    );

    return $cadena;
}

function stripAccents($s){
	$acc =	'É	Ê	Ë	š	Ì	Í	ƒ	œ	µ	Î	Ï	ž	Ð	Ÿ	Ñ	Ò	Ó	Ô	Š	£	Õ	Ö	Œ	¥	Ø	Ž	§	À	Ù	Á	Ú	Â	Û	Ã	Ü	Ä	Ý	';
	$str =	'E	E	E	s	I	I	f	o	m	I	I	z	D	Y	N	O	O	O	S	L	O	O	O	Y	O	Z	S	A	U	A	U	A	U	A	U	A	Y	';
	$acc.=	'Å	Æ	ß	Ç	à	È	á	â	û	Ÿ	ã	ü	Š	ä	ý	š	å	þ	?	æ	ÿ	';
	$str.=	'A	A	S	C	a	E	a	a	u	Y	a	u	S	a	y	s	a	p	-	a	y	';
	$acc.=	'ç	Ž	è	E	ž	é	ê	ë	';
	$str.=	'c	Z	e	E	z	e	e	e	';
	$acc.=	'ì	í	î	Œ	ï	œ	ð	ñ	';
	$str.=	'i	i	i	O	i	o	o	n	';
	$acc.=	'ò	ó	ô	?	õ	ö	Ð	ø	';
	$str.=	'o	o	o	-	o	o	D	o	';
	$acc.=	'ù	ú	:	;	.	,';
	$str.=	'u	u	-	-	.	 ';
	// Se reemplazan acentos y erróneos por sus "equivalentes"
	$string_con_reemplazos = str_replace(explode("\t", $acc), explode("\t", $str), $s);
	
	$val_chars=array(); // array que sólo contendrá caracteres válidos
	$strlen=strlen($string_con_reemplazos); // Largo del string
	$k=0;
	for( $i = 0; $i <= $strlen; $i++ ) {
		$char = substr( $string_con_reemplazos, $i, 1 ); // me quedo con el caracter en particular
		$ord=ord($char);			 // devuelve el código ASCII
		if($ord>=32 && $ord <=125){  // asci imprimible, aceptado para SMS
			if($char!='\'') // éste me impide los inserts !
				$val_chars[$k++]=$char;  // lo agrego al array de caracteres válidos para transmitir
		}
	}
	$out=implode('',$val_chars); // convierto de array a string nuevamente
	return $out;
}

?>